/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 15.7)
 *
 *  Copyright Steve Summit, 1995
 *  Ten kod moe by dowolnie uywany lub modyfikowany, bd wdziczny 
 *  za podanie rda. Nie daj jednak adnej gwarancji jego dziaania, 
 *  ani nie przyjmuj adnej odpowiedzialnoci za skutki jego 
 *  wykorzystania.
 */

#include <stdio.h>
#include <varargs.h>
#include <string.h>

extern char *malloc();

char *vstrcat(va_alist)
va_dcl		/* bez rednika */
{
	int len = 0;
	char *retbuf;
	va_list argp;
	char *p;

	va_start(argp);

	while((p = va_arg(argp, char *)) != NULL)	/* rwnie pierwszy argument */
		len += strlen(p);

	va_end(argp);

	retbuf = malloc(len + 1);		/* +1 na kocowe \0 */

	if(retbuf == NULL)
		return NULL;			/* koniec */

	retbuf[0] = '\0';

	va_start(argp);			/* pocztek drugiego przebiegu */

	while((p = va_arg(argp, char *)) != NULL)	/* rwnie pierwszy argument */
		strcat(retbuf, p);

	va_end(argp);

	return retbuf;
}
